	.msfirst
;__DWROM09_________________________________________________________________________________________
;
;	MINI ROM MONITOR FOR THE N8VEM 6809 HOST PROCESSOR (NO I/O BOARD)
;
;	WRITTEN BY: DAN WERNER -- 11/14/2009
;	based on the ROM by Andrew Lynch
;
;	THIS MONITOR REQUIRES THE Z80 PROCESSOR TO BE RUNNING DWCON09, TO HANDLE I/O
;	FOR THE 6809 HOST PROCESSOR
;__________________________________________________________________________________________________
;
; DATA CONSTANTS
;__________________________________________________________________________________________________
;REGISTER		IO PORT		; FUNCTION
PIA_A		equ	$F000		; PIA PORT A
CON_A		equ	$F001		; PIA CONTROLL A
PIA_B		equ	$F002		; PIA PORT B
CON_B		equ	$F003		; PIA CONTROLL B


	ORG	$F800


;__________________________________________________________________________________________________
;
; 	INITIALIZE 6809 AND PIA FOR ECB COMMUNICATION
;__________________________________________________________________________________________________	
MAIN:
	LDS	#STACK			; RESET STACK POINTER
	CLRA			        ; set direct page register to 0
	TFR	A,DPR			;
	LDAA	#$00			; CLEAR ACCUMULATOR A
	STAA	CON_A			; SET DATA DIRECTION REGISTER A
	STAA	CON_B			; SET DATA DIRECTION REGISTER B
	STAA	PIA_A			; ESTABLISH PA0-PA7 AS INPUTS
	LDAA	#%00101110		; SELECT ORA; SET MODE
	STAA	CON_A			; CONTROL FOR "A" SIDE
	LDAA	#$FF			; ESTABLISH PB0-PB7 AS OUTPUTS
	STAA	PIA_B			;	
	LDAA	#%00101110		; SELECT ORB; SET MODE
	STAA	CON_B			; CONTROL FOR "B" SIDE
	CLRA				; CLEAR ACCUMULATOR A
					;
						
;__CONTRL_________________________________________________________________________________________
;
; 	MONITOR MAIN LOOP
;__________________________________________________________________________________________________
CONTRL:
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	LDAA	#'>'			; CARRIAGE RETURN
	JSR	IOF_CONOUT		; OUTPUT CHARACTER
CONTRL_LOOP:				;
	JSR	IOF_CONIN		; IS INPUT CHARACTER WAITING?
	CMPA	#$00			;
	BEQ	CONTRL_LOOP		; NO, TRY AGAIN
	JSR	IOF_CONOUT		; OUTPUT CHAR TO CONSOLE
					;					
	CMPA	#'D'			; IS DUMP MEMORY?
	BEQ	DUMP			;					
	CMPA	#'L'			; IS LOAD?
	BEQ	LOAD			; YES, JUMP
	CMPA	#'M'			; IS CHANGE?
	BEQ	CHANGE			; YES, JUMP
	CMPA	#'P'			; IS PRINT?
	BEQ	PRINT			; YES, JUMP
	CMPA	#'G'			; IS GO?
	BEQ	GO			; YES JUMP
	CMPA	#'B'			; IS BOOT?
	BEQ	BOOT			; YES JUMP
					;
					; COMMAND NOT FOUND ISSUE ERROR
	LDAA	#'?'			; PRINT '?'
	JSR	IOF_CONOUT		; OUTPUT CHARACTER
	JSR	DISPLAY_CRLF		; DISPLAY CRLF						
	JMP	CONTRL			; RECEIVE NEXT CHARACTER	

BOOT:
	JSR	IOF_BOOT
	JMP	CONTRL			; RECEIVE NEXT CHARACTER	

DUMP:
	JSR 	OUTS			;
	JSR	BADDR			;
	PSHS	X			;
	JSR	OUTS			;
	JSR	BADDR			;
	PULS	X			;
	JSR	DISPLAY_CRLF		;
DUMP_LOOP:	
	JSR	DUMP_LINE		;
	CMPX	XHI			;
	BMI	DUMP_LOOP		;
	JMP	CONTRL			; RECEIVE NEXT CHARACTER	


GO:
	JSR	BADDR			; GET ADDRESS
	JSR	OUTS			; PRINT SPACE
	LDX	XHI			; LOAD X WITH ADDRESS
	JMP	$0000,X			; JUMP TO ADDRESS

; CHANGE MEMORY(M AAAA DD NN)
CHANGE:
	JSR	BADDR			; BUILD ADDRESS
	JSR	OUTS			; PRINT SPACE
	JSR	OUT2HS			;
	JSR	BYTE			;
	DEX				;
	STAA,X				;
	CMPA,X				;
	BNE	LOAD19			; MEMORY DID NOT CHANGE
	JMP	CONTRL			;

; PRINT CONTENTS OF STACK
PRINT:
;	TSX
;	STX	SP		; SAVE STACK POINTER
	STS	SP			;
	LDX	SP			;
	LDAB	#$09			;
PRINT2:					;
	JSR	OUT2HS			; OUT 2 HEX & SPACE
	DECB				;
	BNE	PRINT2			; DONE? IF NO DO MORE
	JMP	CONTRL			; DONE? IF YES RETURN TO MAIN LOOP
			
		


LOAD:
;	LDAA	#$D1		; TURN READER ON
;	STAA	ACIACS
;	LDAA	#@21
;	BSR	OUTCH

LOAD3:
	JSR	IOF_CONINW
	CMPA	#'S'
	BNE	LOAD3		; FIRST CHAR NOT (S)
	JSR	IOF_CONINW	; READ CHAR
	CMPA	#'9'
	BEQ	LOAD21
	CMPA	#'1'
	BNE	LOAD3		; SECOND CHAR NOT (1)
	CLR	CKSM		; ZERO CHECKSUM
	JSR	BYTE		; READ BYTE
	SUBA	#$02		
	STAA	BYTECT		; BYTE COUNT
; BUILD ADDRESS
	BSR	BADDR
; STORE DATA
LOAD11:
	JSR	BYTE
	DEC	BYTECT
	BEQ	LOAD15		; ZERO BYTE COUNT
	STAA,X			; STORE DATA
	INX
	BRA	LOAD11

LOAD15:
	INC	CKSM
	BEQ	LOAD3
LOAD19:
	LDAA	#'?'
	JSR	IOF_CONOUT
LOAD21:
;	LDAA	#$B1		; TURN READER OFF
;	STAA	ACIACS
;	LDAA	#@23
;	BSR	OUTCH
C1	JMP	CONTRL
	

	
DUMP_LINE:
	JSR	OUTADDR			;
	JSR	OUTS			;
	PSHS	X			;
	LDAB	#$10			;		
DUMP_LINE_LOOP:	
	JSR	OUT2HS			; OUT 2 HEX & SPACE
	DECB				;
	BNE	DUMP_LINE_LOOP		; DONE? IF NO DO MORE
	PULS	X			;
	JSR	OUTS			;
	LDAA	#':'			;
	JSR	IOF_CONOUT		;
	LDAB	#$10			;			
DUMP_LINE_LOOPA:		
	LDAA	0,X			;
	CMPA	#32			;
	BMI	DUMP_LINE_INVALID	;
	CMPA	#127			;
	BPL	DUMP_LINE_INVALID	;
	JSR	IOF_CONOUT		;
	JMP	DUMP_LINE_VALID		;
DUMP_LINE_INVALID:			;	
	LDA	#'.'			;
	JSR	IOF_CONOUT		;
DUMP_LINE_VALID:			;
	INX				;	
	DECB				;
	BNE	DUMP_LINE_LOOPA		; DONE? IF NO DO MORE	
	JSR	DISPLAY_CRLF		;
	RTS	
	
; INPUT HEX CHAR
INHEX:
	JSR	IOF_CONINW		;
	PSHS	A			;
	JSR	IOF_CONOUT		;
	PULS	A			;
	CMPA	#$30			;
	BMI	C1			; NOT HEX
	CMPA	#$39			;
	BLE	IN1HG			;
	CMPA	#$41			;
	BMI	C1			; NOT HEX
	CMPA	#$46			;
	BGT	C1			; NOT HEX
	SUBA	#$07			;
IN1HG:					;
	RTS				;

; BUILD ADDRESS
BADDR:
	BSR	BYTE		; READ 2 FRAMES
	STAA	XHI
	BSR	BYTE
	STAA	XLOW
	LDX	XHI		; (X) ADDRESS WE BUILT
	RTS

; INPUT BYTE (TWO FRAMES)
BYTE:
	BSR	INHEX		; GET HEX CHAR
	ASLA
	ASLA
	ASLA
	ASLA
	TAB
	BSR	INHEX
	ANDA	#$0F		; MASK TO 4 BITS
	ABA
	TAB
	ADDB	CKSM
	STAB	CKSM
	RTS



OUTHL:
	LSRA			; OUT HEX LEFT BCD DIGIT
	LSRA			;
	LSRA			;
	LSRA			;

OUTHR:				;
	ANDA	#$0F		; OUT HEC RIGHT DIGIT
	ADDA	#$30		;
	CMPA	#$39		;
	BLS	OUTHR1		;
	ADDA	#$07		;
OUTHR1:	
	JMP	IOF_CONOUT	;

OUT2H:
	LDAA	0,X		; OUTPUT 2 HEX CHAR
	BSR	OUTHL		; OUT LEFT HEX CHAR
	LDAA	0,X		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	INX
	RTS
	
OUTADDR:
	PSHS	X		;
	PULS	A		;
	PSHS	A		;
	BSR	OUTHL		; OUT LEFT HEX CHAR
	PULS	A		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	PULS	A		;
	PSHS	A		;
	BSR	OUTHL		; OUT LEFT HEX CHAR
	PULS	A		;
	BSR	OUTHR		; OUT RIGHT HEX CHAR
	RTS	

OUT2HS:
	BSR	OUT2H		; OUTPUT 2 HEX CHAR + SPACE
OUTS:
	LDAA	#$20		; SPACE
	JMP	IOF_CONOUT	;

;__________________________________________________________________________________________________________	
	
DISPLAY_CRLF:	
	LDAA	#$0D			; PRINT CR
	JSR	IOF_CONOUT		; OUTPUT CHARACTER
	LDAA	#$0A			; PRINT LF
	JSR	IOF_CONOUT		; OUTPUT CHARACTER
	RTS	

IOF_CONINW:				;
	JSR	IOF_CONIN		;
	CMPA	#$00			;
	BEQ	IOF_CONINW		;
	RTS
	
IOF_CONIN:				;
	LDAA	#$01			; FUNCTION 01, GET KB IN
	JSR	ECB_OUTCHAR		; SEND FUNCTION REQUEST
	JSR	ECB_INCHAR		; FUNCTION RETURNS ONE BYTE
	BCC	IOF_CONIN_SUCCESS	;
	LDAA	#$00			; TIMED OUT
IOF_CONIN_SUCCESS:			;	
	RTS				;
	
IOF_CONOUT:				;
	PSHS	A			; STORE A
	LDAA	#$02			; FUNCTION 01, GET KB IN
	JSR	ECB_OUTCHAR		; SEND FUNCTION REQUEST
	PULS	A			; RESTORE A
	JSR	ECB_OUTCHAR		; FUNCTION REQUIRES ONE BYTE PARAMETER
	
	RTS

	
IOF_BOOT:
	LDAA	#$F0			; FUNCTION F0, LOAD CUBIX IMAGE
	JSR	ECB_OUTCHAR		; SEND FUNCTION REQUEST		
	JSR	ECB_DEC_CHARIN		; SEND FUNCTION REQUEST		
	CMPA	#$FF			;
	BEQ	IOF_BOOTA		;
	LDX	#$C700			; DEST ADDRESS
	LDY	#$0000			;
IOF_BOOT1:
	LDA	#$06			; GET DISK BUFFER BYTE
	JSR	ECB_OUTCHAR		;
	PSHS	Y			;
	PULS	A			;	
	JSR	ECB_ENC_OUTCHAR		;
	PULS	A			;
	JSR	ECB_ENC_OUTCHAR		;
	JSR	ECB_DEC_CHARIN		; GET NEXT BYTE
	STA	,X+			; WRITE IT TO CUBIX RAM	
	INY				; BUMP COUNT
	CMPX	#$F000			;
	BNE	IOF_BOOT1		; DONE? NO, LOOP
	JMP	$C808
IOF_BOOTA:	
	RTS


;__ECB_DEC_CHARIN_____________________________________________________________________________________ 
;
;	GET A DECODED BYTE FROM THE M6809
;	A= RETURNED BYTE
;
;	THIS WILL RETURN ALL BYTES
;_____________________________________________________________________________________________________
;
ECB_DEC_CHARIN:
	JSR	ECB_INCHAR		; GET BYTE
	BCS	ECB_DEC_CHARIN		;
	RTS				;
	
			
ECB_ENC_OUTCHAR:			;
	CMPA	#27			; IS 27?
	BEQ	ECB_ENC_OUTCHAR_27	;
	CMPA	#00			; IS NULL?
	BEQ	ECB_ENC_OUTCHAR_00	;
	BRA	ECB_OUTCHAR		;
ECB_ENC_OUTCHAR_27:			;
	JSR	ECB_OUTCHAR		;
	LDAA	#27			;
	BRA	ECB_OUTCHAR		;
ECB_ENC_OUTCHAR_00:			;
	LDAA	#27			;
	JSR	ECB_OUTCHAR		;
	LDAA	#'0'			;
	BRA	ECB_OUTCHAR		;
	
	
ECB_INCHAR:				;
	PSHS	X			;
	LDX	#$FFFF			;
ECB_INCHAR_LOOP:			;
	DEX				;
	CMPX	#$0000			;
	BEQ	ECB_INCHAR_ABORT	;
	TST	CON_A			; IS BYTE READY (CA1 TRANSITION)
	BPL	ECB_INCHAR_LOOP		; NO, TRY AGAIN
	LDAA	PIA_A			; READ FROM PORT A WITH CA2 STROBES
	PULS	X			;
	CLC				; SIGNAL SUCCESS
	RTS				;
ECB_INCHAR_ABORT:			;
	PULS	X			;
	SEC				; SIGNAL FAILURE
	RTS				;

ECB_OUTCHAR:				;
	PSHS	B			; SAVE B-REG (COUNTER)
	STAA	PIA_B			; WRITE TO PORT B WITH CB2 STROBES
	LDAA	PIA_B			; RESET BIT 7 CRB
ECB_OUTCHAR_LOOP:			;
	TST	CON_B			; IS BYTE READY (CB1 TRANSITION)
	BPL	ECB_OUTCHAR_LOOP	; NO, TRY AGAIN
	LDAB	PIA_B			; RESET BIT 7 CRA WITH OUTPUT REGISTER READ
	PULS	B			; RESTORE B-REG
	RTS
	
	


; DATA
STACK	EQU	$0100		; STACK POINTER

; REGISTERS FOR GO
;	FCB	$00		; CONDITION CODES
;	FCB	$00		; B ACCUMULATOR
;	FCB	$00		; A
;	FCB	$00		; X-HIGH
;	FCB	$00		; X-LOW
;	FCB	$00		; P-HIGH
;	FCB	$00		; P-LOW
SP	EQU	$0108		; S-HIGH
;	FCB	$00		; S-LOW
	
; END REGISTERS FOR GO
CKSM	EQU	$010A		; CHECKSUM
BYTECT	EQU	$010B		; BYTE COUNT
XHI	EQU	$010C		; XREG HIGH
XLOW	EQU	$010D		; XREG LOW

* NO VDU
*	org	$FFF2
*	FCW	$E75C
*	FCW	$E758
*	FCW	$E764
*	FCW	$E760
*	FCW	$E754
*	FCW	$E768

* WITH VDU	
	org	$FFF2
	FCW	$DE5C
	FCW	$DE58
	FCW	$DE64
	FCW	$DE60
	FCW	$DE54
	FCW	$DE68
	
	
	ORG	$FFFE		; SET RESET VECTOR TO MAIN PROGRAM
RESETV	FCW	MAIN

	END
